/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.IIndexReporter;
import com.aptana.editor.php.indexer.IReportable;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.contentAssist.AcceptAllContextFilter;
import com.aptana.editor.php.internal.contentAssist.AutoActivateContentAssistProposal;
import com.aptana.editor.php.internal.contentAssist.CallInfo;
import com.aptana.editor.php.internal.contentAssist.ContentAssistCollectors;
import com.aptana.editor.php.internal.contentAssist.ContentAssistFilters;
import com.aptana.editor.php.internal.contentAssist.ContentAssistUtils;
import com.aptana.editor.php.internal.contentAssist.EntryDocumentationResolver;
import com.aptana.editor.php.internal.contentAssist.IContextFilter;
import com.aptana.editor.php.internal.contentAssist.IDocumentationResolver;
import com.aptana.editor.php.internal.contentAssist.PHPCompletionProposal;
import com.aptana.editor.php.internal.contentAssist.PHPContextCalculator;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.contentAssist.ParsingUtils;
import com.aptana.editor.php.internal.contentAssist.ProposalContext;
import com.aptana.editor.php.internal.contentAssist.ProposalEnhancement;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.AccessModifierEntryFilter;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ElementsIndexingUtils;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.IEntryFilter;
import com.aptana.editor.php.internal.indexer.ModuleSubstitutionIndex;
import com.aptana.editor.php.internal.indexer.NamespacePHPEntryValue;
import com.aptana.editor.php.internal.indexer.PDTPHPModuleIndexer;
import com.aptana.editor.php.internal.indexer.PHPTypeProcessor;
import com.aptana.editor.php.internal.indexer.PublicsOnlyEntryFilter;
import com.aptana.editor.php.internal.indexer.TraitPHPEntryValue;
import com.aptana.editor.php.internal.indexer.UnpackedElementIndex;
import com.aptana.editor.php.internal.indexer.UnpackedEntry;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.indexer.language.PHPBuiltins;
import com.aptana.editor.php.internal.model.utils.TypeHierarchyUtils;
import com.aptana.editor.php.internal.parser.nodes.IPHPParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPBaseParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPVariableParseNode;
import com.aptana.editor.php.internal.parser.nodes.Parameter;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.editor.php.internal.ui.editor.PHPVersionDocumentManager;
import com.aptana.editor.php.internal.ui.editor.contentassist.PHPContextInformationValidator;
import com.aptana.editor.php.internal.ui.editor.outline.PHPDecoratingLabelProvider;
import com.aptana.editor.php.internal.ui.editor.outline.PHPOutlineItem;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org2.eclipse.php.core.compiler.PHPFlags;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer;
import org2.eclipse.php.internal.core.documentModel.parser.PhpLexerFactory;

public class PHPContentAssistProcessor
extends CommonContentAssistProcessor
implements IContentAssistProcessor {
    private static final int CONTEXT_INFO_MAX_LOOK_BEHIND = 100;
    private static final IContextInformation[] EMPTY_CONTEXT_INFO = new IContextInformation[0];
    private static final int EXTERNAL_CLASS_PROPOSAL_RELEVANCE = 40;
    private static final int EXTERNAL_FUNCTION_PROPOSAL_RELEVANCE = 35;
    private static final int EXTERNAL_CONSTANT_PROPOSAL_RELEVANCE = 30;
    private static final int EXTERNAL_DEFAULT_PROPOSAL_RELEVANCE = 25;
    private static final ICompletionProposal[] EMPTY_PROPOSAL = new ICompletionProposal[0];
    protected static final String DOLLAR_SIGN = "$";
    public static final String GLOBAL_NAMESPACE = "\\";
    public static final String DEREFERENCE_OP = "->";
    public static final String STATIC_DEREFERENCE_OP = "::";
    public static final String[] OPS = new String[]{"->", "::"};
    private static final String THIS_ACTIVATION_SEQUENCE = "$this";
    private static final String SELF_ACTIVATION_SEQUENCE = "self";
    private static final String STATIC_ACTIVATION_SEQUENCE = "static";
    private static final String PARENT_ACTIVATION_SEQUENCE = "parent";
    private static final Set<String> ALLOW_ONLY_UNDER_CLASS = new HashSet<String>(Arrays.asList("$this", "self", "parent", "public", "private", "protected"));
    private static final IRange EMPTY_RANGE = new Range(0, 0);
    private static Image fIcon54 = PHPEditorPlugin.getImage("icons/full/obj16/v54.png");
    private static Image fIcon53 = PHPEditorPlugin.getImage("icons/full/obj16/v53.png");
    private static Image fIcon5 = PHPEditorPlugin.getImage("icons/full/obj16/v5.png");
    private static Image fIcon4 = PHPEditorPlugin.getImage("icons/full/obj16/v4.png");
    private static Image fIcon54off = PHPEditorPlugin.getImage("icons/full/obj16/v54_off.png");
    private static Image fIcon53off = PHPEditorPlugin.getImage("icons/full/obj16/v53_off.png");
    private static Image fIcon5off = PHPEditorPlugin.getImage("icons/full/obj16/v5_off.png");
    private static Image fIcon4off = PHPEditorPlugin.getImage("icons/full/obj16/v4_off.png");
    private static char[] autoactivationCharacters = new char[]{'>', '@', ':', '\\', ' '};
    private static final char[] contextInformationActivationChars = new char[]{'(', ','};
    private static final Set<String> TYPES_ACCEPTING_EMPTY_IDENTIFIERS = CollectionsUtil.newSet((Object[])new String[]{"EXTENDS_PROPOSAL_CONTEXT_TYPE", "IMPLEMENTS_PROPOSAL_CONTEXT_TYPE", "NEW_PROPOSAL_CONTEXT_TYPE", "TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE", "TRAIT_USE_PROPOSAL_CONTEXT_TYPE"});
    private static PHPDecoratingLabelProvider labelProvider = new PHPDecoratingLabelProvider();
    private ITextViewer viewer;
    private int offset;
    private String content;
    private boolean reportedScopeIsGlobal = true;
    private boolean reportedScopeIsUnderClass = false;
    private Set<String> globalImports;
    private Map<String, String> aliases;
    private String namespace;
    private IModule module;
    private ProposalContext currentContext;
    private PHPContextCalculator contextCalculator;
    private IPreferenceStore preferenceStore;
    private boolean isOutOfWorkspace;
    private IDocument document;

    public PHPContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
        if (editor == null) {
            throw new IllegalArgumentException("Expected PHPSourceEditor, but got null");
        }
        if (!(editor instanceof PHPSourceEditor)) {
            throw new IllegalArgumentException("Expected PHPSourceEditor, but got " + editor.getClass().getName());
        }
        this.preferenceStore = PHPEditorPlugin.getDefault().getPreferenceStore();
        this.currentContext = new ProposalContext(new AcceptAllContextFilter(), true, true, null);
        this.contextCalculator = new PHPContextCalculator();
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        try {
            String openPhp = document.get(Math.max(0, offset - 4), Math.min(Math.min(offset, 4), document.getLength() - 1));
            if (openPhp.endsWith("<?") || openPhp.endsWith("<?p") || openPhp.endsWith("<?ph")) {
                return false;
            }
        }
        catch (Exception exception) {}
        ILexemeProvider<PHPTokenType> lexemeProvider = ParsingUtils.createLexemeProvider(document, offset);
        this.currentContext = this.contextCalculator.calculateCompletionContext(lexemeProvider, offset, c, this.reportedScopeIsUnderClass);
        return this.currentContext.acceptModelsElements() || this.currentContext.isAutoActivateCAAfterApply();
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c);
    }

    protected Collection<ICompletionProposal> addSnippetProposals(ITextViewer viewer, int offset) {
        if (this.currentContext != null && !this.currentContext.acceptExternalProposals()) {
            return Collections.emptyList();
        }
        return super.addSnippetProposals(viewer, offset);
    }

    protected List<ICompletionProposal> addRubleProposals(ITextViewer viewer, int offset) {
        if (this.currentContext != null && !this.currentContext.acceptExternalProposals()) {
            return Collections.emptyList();
        }
        return super.addRubleProposals(viewer, offset);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.viewer = viewer;
        this.document = viewer.getDocument();
        return this.computeCompletionProposals(this.document, offset);
    }

    public ICompletionProposal[] computeCompletionProposals(IDocument document, int offset) {
        Boolean fa;
        int startOffset;
        ITypedRegion partition;
        try {
            int length = document.getLength();
            partition = length == offset && length > 0 ? document.getPartition(offset - 1) : document.getPartition(offset);
            if (!partition.getType().startsWith("__php_")) {
                return null;
            }
        }
        catch (BadLocationException e1) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error computing PHP completion proposals", (Throwable)e1);
            return null;
        }
        PHPVersion phpVersion = PHPVersionDocumentManager.getPHPVersion(document);
        if (phpVersion == null) {
            phpVersion = PHPVersionProvider.getDefaultPHPVersion();
        }
        ILexemeProvider<PHPTokenType> lexemeProvider = ParsingUtils.createLexemeProvider(document, offset);
        this.getIndex(this.content, offset);
        this.currentContext = this.contextCalculator.calculateCompletionContext(lexemeProvider, offset, this.reportedScopeIsUnderClass);
        String content = document.get();
        AbstractPhpLexer lexer = PhpLexerFactory.createLexer((Reader)new StringReader(content), (PHPVersion)phpVersion);
        int state = -1;
        try {
            state = lexer.getClass().getField("ST_PHP_IN_SCRIPTING").getInt(lexer);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error grabbing a field from the PHP lexer", (Throwable)e);
            return null;
        }
        lexer.initialize(state);
        lexer.setPatterns(null);
        lexer.setAspTags(true);
        String prev = null;
        String prev2 = null;
        String lastN = null;
        StringBuilder contentS = null;
        try {
            while (true) {
                String next_token = lexer.getNextToken();
                int left = lexer.getTokenStart();
                int right = left + lexer.yylength();
                String value = lexer.yytext();
                if (next_token == "PHP_NS_SEPARATOR" || next_token == "PHP_USE") {
                    lastN = next_token;
                    contentS = new StringBuilder();
                } else if (lastN != null) {
                    if (next_token == "PHP_STRING" || next_token == "PHP_NS_SEPARATOR") {
                        contentS.append(value == null ? Character.valueOf('\\') : value);
                    } else {
                        lastN = null;
                    }
                }
                if (left < offset && right > offset && next_token == "PHP_CONSTANT_ENCAPSED_STRING") {
                    if ((prev2 != null || prev != null) && (this.checkInclude(prev2) || this.checkInclude(prev))) {
                        return EMPTY_PROPOSAL;
                    }
                    return EMPTY_PROPOSAL;
                }
                if (!(next_token == null || "PHP_CLOSETAG".equals(next_token) && "PHP_CLOSETAG".equals(prev))) {
                    prev2 = prev;
                    prev = next_token;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error computing PHP completion proposals", (Throwable)e);
        }
        int a = startOffset = offset < content.length() ? offset : offset - 1;
        while (a >= 0) {
            char c = content.charAt(a);
            if (c < ' ') break;
            if (c == '/' && a > 0 && content.charAt(a - 1) == '/') {
                return EMPTY_PROPOSAL;
            }
            --a;
        }
        boolean forceActivation = false;
        Boolean bl = fa = this.viewer != null && this.viewer.getTextWidget() != null ? (Boolean)this.viewer.getTextWidget().getData("ASSIST_FORCE_ACTIVATION") : null;
        if (fa != null) {
            forceActivation = fa;
        }
        int replaceLengthIncrease = this.countReplaceLengthIncrease(content, offset);
        ICompletionProposal[] computeCompletionProposalInternal = this.computeCompletionProposalInternal(partition, offset, content, true, forceActivation);
        if (computeCompletionProposalInternal.length > 0 && replaceLengthIncrease > 0) {
            computeCompletionProposalInternal = PHPContentAssistProcessor.batchIncreaseReplaceLength(computeCompletionProposalInternal, replaceLengthIncrease);
        }
        if (this.viewer != null && this.viewer.getTextWidget() != null) {
            this.viewer.getTextWidget().setData("ASSIST_FORCE_ACTIVATION", (Object)false);
        }
        return computeCompletionProposalInternal;
    }

    public ICompletionProposal[] computeCompletionProposalInternal(ITypedRegion partition, int offset, String content, boolean proposeBuiltins, boolean forceActivation) {
        int start = offset == 0 ? 0 : offset - 1;
        this.offset = offset;
        this.content = content;
        List<String> callPath = ParsingUtils.parseCallPath(partition, content, start, OPS, false, this.document);
        if (callPath == null || callPath.isEmpty()) {
            return EMPTY_PROPOSAL;
        }
        if (callPath.size() > 1) {
            if (this.hasStaticDereferenceOperatorAfterTheFirst(callPath)) {
                return EMPTY_PROPOSAL;
            }
            if (content.charAt(start) == '(') {
                return EMPTY_PROPOSAL;
            }
            if (DEREFERENCE_OP.equals(callPath.get(1))) {
                return this.dereferencingCompletion(this.getIndex(content, start), callPath, start, this.getModule());
            }
            if (callPath.size() > 3 && DEREFERENCE_OP.equals(callPath.get(3))) {
                return this.dereferencingCompletion(this.getIndex(content, start), callPath, start, this.getModule());
            }
            return this.dereferencingStaticCompletion(this.getIndex(content, start), callPath, start, this.getModule());
        }
        if (callPath.size() == 1) {
            if (forceActivation && !this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.AUTO_ACTIVATE_ON_IDENTIFIERS")) {
                return EMPTY_PROPOSAL;
            }
            String identifier = callPath.get(0);
            if (identifier.startsWith(GLOBAL_NAMESPACE)) {
                return this.computeNamespaceCompletion(start, content, identifier, this.globalImports, this.getModule(), proposeBuiltins, true);
            }
            return this.simpleIdentifierCompletion(start, content, identifier, this.globalImports, this.getModule(), proposeBuiltins, true, false);
        }
        return EMPTY_PROPOSAL;
    }

    private ICompletionProposal[] computeNamespaceCompletion(int offset, String content, String identifier, Set<String> globalImports, IModule module, boolean proposeBuiltins, boolean filter) {
        identifier = identifier.substring(1);
        return this.simpleIdentifierCompletion(offset, content, identifier, globalImports, module, proposeBuiltins, filter, true);
    }

    private ICompletionProposal[] dereferencingCompletion(IElementsIndex index, List<String> callPath, int offset, IModule module) {
        Set<IElementEntry> result = PHPContentAssistProcessor.computeDereferenceEntries(index, callPath, offset == 0 ? 0 : offset - 1, module, false, this.aliases, this.namespace);
        if (result == null || result.isEmpty()) {
            return new ICompletionProposal[0];
        }
        ArrayList<PHPCompletionProposal> proposals = new ArrayList<PHPCompletionProposal>();
        LinkedHashSet<String> usedName = new LinkedHashSet<String>();
        for (IElementEntry currentEntry : result) {
            String lastName = ElementsIndexingUtils.getLastNameInPath(currentEntry.getEntryPath());
            if (usedName.contains(lastName)) continue;
            PHPCompletionProposal proposal = this.createProposal(currentEntry, offset, callPath.get(callPath.size() - 1), lastName, module, false, index, false);
            if (proposal != null) {
                proposals.add(proposal);
            }
            usedName.add(lastName);
        }
        ICompletionProposal[] toReturn = new ICompletionProposal[proposals.size()];
        return proposals.toArray(toReturn);
    }

    public static Set<IElementEntry> computeDereferenceEntries(IElementsIndex index, List<String> callPath, int offset, IModule module, boolean exactMatch, Map<String, String> aliases, String namespace) {
        String entryName = callPath.get(0);
        Set<IElementEntry> leftDereferenceEntries = null;
        leftDereferenceEntries = STATIC_DEREFERENCE_OP.equals(callPath.get(1)) || SELF_ACTIVATION_SEQUENCE.equals(entryName) || STATIC_ACTIVATION_SEQUENCE.equals(entryName) ? PHPContentAssistProcessor.computeStaticDereferenceLeftEntries(index, PHPContentAssistProcessor.pathEntryName(entryName), offset, module, aliases, namespace) : PHPContentAssistProcessor.computeDereferenceLeftEntries(index, PHPContentAssistProcessor.pathEntryName(entryName), offset, module, aliases, namespace);
        if (leftDereferenceEntries == null) {
            return null;
        }
        if (leftDereferenceEntries.isEmpty() && ParsingUtils.isFunctionCall(callPath.get(0))) {
            leftDereferenceEntries.addAll(PHPContentAssistProcessor.computeSimpleIdentifierEntries(true, Collections.EMPTY_SET, PHPContentAssistProcessor.pathEntryName(entryName), false, index, false, module, false, "", Collections.EMPTY_MAP));
        }
        boolean innerCompletion = false;
        if (THIS_ACTIVATION_SEQUENCE.equals(callPath.get(0))) {
            innerCompletion = true;
        }
        Set<IElementEntry> result = null;
        int i = 2;
        while (i < callPath.size()) {
            String callPathEntry;
            boolean currentExactMatchFlag = true;
            boolean applyAccessRestriction = false;
            if (i == callPath.size() - 1) {
                currentExactMatchFlag = exactMatch;
                applyAccessRestriction = true;
            }
            if ((result = PHPContentAssistProcessor.computeDereferenceRightEntries(leftDereferenceEntries, index, PHPContentAssistProcessor.pathEntryName(callPathEntry = callPath.get(i)), offset, module, currentExactMatchFlag, applyAccessRestriction, innerCompletion, aliases, namespace)) == null || result.isEmpty()) {
                return null;
            }
            leftDereferenceEntries = result;
            i += 2;
        }
        return result;
    }

    private ICompletionProposal[] dereferencingStaticCompletion(IElementsIndex index, List<String> callPath, int offset, IModule module) {
        Set<IElementEntry> result = PHPContentAssistProcessor.computeStaticDereferenceEntries(index, callPath, offset == 0 ? 0 : offset - 1, module, false, this.aliases, this.namespace);
        if (result == null || result.isEmpty()) {
            return new ICompletionProposal[0];
        }
        ArrayList<PHPCompletionProposal> proposals = new ArrayList<PHPCompletionProposal>();
        LinkedHashSet<String> usedName = new LinkedHashSet<String>();
        for (IElementEntry currentEntry : result) {
            PHPCompletionProposal proposal;
            String lastName = ElementsIndexingUtils.getLastNameInPath(currentEntry.getEntryPath());
            if (PHPContentAssistProcessor.isVariableEntry(currentEntry) && !PHPContentAssistProcessor.isConstVariable(currentEntry)) {
                lastName = DOLLAR_SIGN + lastName;
            }
            if (usedName.contains(lastName) || (proposal = this.createProposal(currentEntry, offset, callPath.get(callPath.size() - 1), lastName, module, !PHPContentAssistProcessor.isConstVariable(currentEntry), index, false)) == null) continue;
            proposals.add(proposal);
            usedName.add(lastName);
        }
        ICompletionProposal[] toReturn = new ICompletionProposal[proposals.size()];
        return proposals.toArray(toReturn);
    }

    public static Set<IElementEntry> computeStaticDereferenceEntries(IElementsIndex index, List<String> callPath, int offset, IModule module, boolean exactMatch, Map<String, String> aliases, String namespace) {
        Set<IElementEntry> result;
        Set<IElementEntry> leftDereferenceEntries = PHPContentAssistProcessor.computeStaticDereferenceLeftEntries(index, PHPContentAssistProcessor.pathEntryName(callPath.get(0)), offset, module, aliases, namespace);
        if (leftDereferenceEntries == null || leftDereferenceEntries.isEmpty()) {
            return null;
        }
        boolean selfCompletion = SELF_ACTIVATION_SEQUENCE.equals(callPath.get(0));
        boolean staticCompletion = STATIC_ACTIVATION_SEQUENCE.equals(callPath.get(0));
        boolean parentCompletion = PARENT_ACTIVATION_SEQUENCE.equals(callPath.get(0));
        boolean currentExactMatch = true;
        if (callPath.size() == 3) {
            currentExactMatch = exactMatch;
        }
        if (leftDereferenceEntries.size() == 1) {
            if (parentCompletion) {
                Object entryValue = leftDereferenceEntries.iterator().next().getValue();
                if (entryValue instanceof ClassPHPEntryValue) {
                    namespace = ((ClassPHPEntryValue)entryValue).getNameSpace();
                }
            } else {
                parentCompletion = leftDereferenceEntries.iterator().next().getValue() instanceof TraitPHPEntryValue;
            }
        }
        if ((result = PHPContentAssistProcessor.computeStaticDereferenceRightEntries(index, leftDereferenceEntries, PHPContentAssistProcessor.pathEntryName(callPath.get(2)), offset, module, currentExactMatch, true, selfCompletion || staticCompletion, parentCompletion, aliases, namespace)) == null || result.isEmpty()) {
            return null;
        }
        if (callPath.size() > 3) {
            leftDereferenceEntries = result;
            int i = 4;
            while (i < callPath.size()) {
                currentExactMatch = true;
                boolean applyAccessRestriction = false;
                if (i == callPath.size() - 1) {
                    currentExactMatch = exactMatch;
                    applyAccessRestriction = true;
                }
                if ((result = PHPContentAssistProcessor.computeDereferenceRightEntries(leftDereferenceEntries, index, PHPContentAssistProcessor.pathEntryName(callPath.get(i)), offset, module, currentExactMatch, applyAccessRestriction, selfCompletion, aliases, namespace)) == null || result.isEmpty()) {
                    return null;
                }
                leftDereferenceEntries = result;
                i += 2;
            }
        }
        return result;
    }

    private static Set<IElementEntry> computeStaticDereferenceRightEntries(IElementsIndex index, Set<IElementEntry> leftEntries, String right, int offset, IModule module, boolean exactMatch, boolean applyAccessModifiers, boolean innerEntries, boolean parentEntries, Map<String, String> aliases, String namespace) {
        if (leftEntries == null || leftEntries.isEmpty()) {
            return null;
        }
        Set<Object> leftTypes = PHPContentAssistProcessor.getEntriesTypes(leftEntries);
        if (leftTypes == null || leftTypes.isEmpty()) {
            return null;
        }
        Set<String> resolvedLeftTypes = PHPTypeProcessor.processTypes(leftTypes, index);
        if (resolvedLeftTypes == null || resolvedLeftTypes.isEmpty()) {
            return null;
        }
        Set<String> customLeftTypes = PHPTypeProcessor.getCustomTypes(resolvedLeftTypes);
        if (customLeftTypes == null || customLeftTypes.isEmpty()) {
            return null;
        }
        IEntryFilter filter = null;
        if (applyAccessModifiers) {
            filter = innerEntries ? new AccessModifierEntryFilter(customLeftTypes, false) : (parentEntries ? new AccessModifierEntryFilter(customLeftTypes, true) : new PublicsOnlyEntryFilter());
        }
        Set<String> typesWithAncestors = TypeHierarchyUtils.addAllAncestors(customLeftTypes, index, namespace, aliases);
        Set<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        if (right.length() == 0) {
            Set<IElementEntry> constResults;
            Set<IElementEntry> funcResults;
            Set<IElementEntry> varResults = ContentAssistCollectors.collectVariableEntries(index, DOLLAR_SIGN, typesWithAncestors, exactMatch, aliases, namespace);
            if (varResults != null) {
                result.addAll(varResults);
            }
            if ((funcResults = ContentAssistCollectors.collectFunctionEntries(index, right, typesWithAncestors, exactMatch, aliases, namespace)) != null) {
                result.addAll(funcResults);
            }
            if ((constResults = ContentAssistCollectors.collectConstEntries(index, right, typesWithAncestors, exactMatch, aliases, namespace)) != null) {
                result.addAll(constResults);
            }
        } else if (right.startsWith(DOLLAR_SIGN)) {
            result.addAll(ContentAssistCollectors.collectVariableEntries(index, right, typesWithAncestors, exactMatch, aliases, namespace));
        } else {
            result.addAll(ContentAssistCollectors.collectConstEntries(index, right, typesWithAncestors, exactMatch, aliases, namespace));
            result.addAll(ContentAssistCollectors.collectFunctionEntries(index, right, typesWithAncestors, exactMatch, aliases, namespace));
        }
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (!parentEntries) {
            result = ContentAssistFilters.filterStaticEntries(result);
        }
        if (filter != null) {
            result = filter.filter(result);
        }
        return ContentAssistFilters.filterByModule(result, module, index);
    }

    private static Set<Object> getEntriesTypes(Collection<IElementEntry> entries) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (IElementEntry entry : entries) {
            Set<Object> entryTypes = PHPContentAssistProcessor.getEntryTypes(entry);
            HashSet<Object> splittedTypes = new HashSet<Object>(entryTypes.size() + 2);
            for (Object type : entryTypes) {
                if (type instanceof String) {
                    String[] types;
                    String t = type.toString();
                    String[] stringArray = types = t.split("\\|");
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String splittedType = stringArray[n2];
                        String resolvedType = splittedType.trim();
                        if (resolvedType.startsWith(GLOBAL_NAMESPACE)) {
                            resolvedType = resolvedType.substring(1);
                        }
                        splittedTypes.add(resolvedType);
                        ++n2;
                    }
                    continue;
                }
                splittedTypes.add(type);
            }
            result.addAll(splittedTypes);
        }
        return result;
    }

    private static Set<Object> getEntryTypes(IElementEntry entry) {
        if (PHPContentAssistProcessor.isVariableEntry(entry)) {
            return ((VariablePHPEntryValue)entry.getValue()).getTypes();
        }
        if (PHPContentAssistProcessor.isFunctionEntry(entry)) {
            return ((FunctionPHPEntryValue)entry.getValue()).getReturnTypes();
        }
        if (PHPContentAssistProcessor.isClassEntry(entry)) {
            HashSet<Object> result = new HashSet<Object>(1);
            result.add(ElementsIndexingUtils.getFirstNameInPath(entry.getEntryPath()));
            return result;
        }
        return Collections.emptySet();
    }

    private static Set<IElementEntry> computeStaticDereferenceLeftEntries(IElementsIndex index, String left, int offset, IModule module, Map<String, String> aliases, String namespace) {
        if (left.startsWith(DOLLAR_SIGN)) {
            IProject project = PHPContentAssistProcessor.getProject(module);
            if (project != null && !PHPVersionProvider.isPHP53(project)) {
                return null;
            }
            return PHPContentAssistProcessor.computeDereferenceLeftEntries(index, left, offset, module, aliases, namespace);
        }
        if (SELF_ACTIVATION_SEQUENCE.equals(left) || STATIC_ACTIVATION_SEQUENCE.equals(left)) {
            IElementEntry currentClass = PHPContentAssistProcessor.getCurrentClass(index, module, offset);
            if (currentClass == null) {
                return null;
            }
            LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
            result.add(currentClass);
            return result;
        }
        if (PARENT_ACTIVATION_SEQUENCE.equals(left)) {
            ClassPHPEntryValue classPHPEntryValue;
            String superClassname;
            IElementEntry currentClass = PHPContentAssistProcessor.getCurrentClass(index, module, offset);
            if (currentClass == null) {
                return null;
            }
            LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
            Object clazz = currentClass.getValue();
            if (clazz instanceof ClassPHPEntryValue && (superClassname = (classPHPEntryValue = (ClassPHPEntryValue)clazz).getSuperClassname()) != null) {
                Set<IElementEntry> superClassEntry;
                String resolvedSuperclassNamespace = PHPContentAssistProcessor.resolveNamespace(superClassname);
                if (StringUtil.isEmpty((String)resolvedSuperclassNamespace)) {
                    resolvedSuperclassNamespace = namespace;
                }
                if ((superClassEntry = PHPContentAssistProcessor.getClassEntries(index, superClassname, module, aliases, resolvedSuperclassNamespace, true)) != null && superClassEntry.size() == 1) {
                    result.addAll(superClassEntry);
                }
            }
            return result;
        }
        return PHPContentAssistProcessor.getClassEntries(index, left, module, aliases, namespace, true);
    }

    private static String resolveNamespace(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return path;
        }
        try {
            IPath p = Path.fromOSString((String)path.replaceAll("\\\\", "/"));
            if (p.segmentCount() > 1) {
                String resolvedNamespace = p.removeLastSegments(1).toString();
                if (resolvedNamespace.startsWith(GLOBAL_NAMESPACE) || resolvedNamespace.startsWith("/")) {
                    resolvedNamespace = resolvedNamespace.substring(1);
                }
                return resolvedNamespace.replace("/", GLOBAL_NAMESPACE);
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static IProject getProject(IModule module) {
        if (module == null || !(module instanceof LocalModule)) {
            return null;
        }
        LocalModule lm = (LocalModule)module;
        IFile file = lm.getFile();
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    private static IElementEntry getCurrentClass(IElementsIndex index, IModule module, int offset) {
        List<IElementEntry> entries = index.getModuleEntries(module);
        for (IElementEntry entry : entries) {
            ClassPHPEntryValue val;
            if (entry.getCategory() != 1 || !(entry.getValue() instanceof ClassPHPEntryValue) || (val = (ClassPHPEntryValue)entry.getValue()).getStartOffset() >= offset || val.getEndOffset() <= offset) continue;
            return entry;
        }
        return null;
    }

    private static Set<IElementEntry> getClassEntries(IElementsIndex index, String clazz, IModule module, Map<String, String> aliases, String namespace, boolean isStaticDereferencing) {
        if (clazz != null && clazz.startsWith(GLOBAL_NAMESPACE)) {
            clazz = clazz.substring(1);
        }
        List<IElementEntry> namespaceEntries = PHPContentAssistProcessor.getNamespaceEntries(clazz, module, aliases);
        List<IElementEntry> leftEntries = index.getEntries(1, clazz);
        if (CollectionsUtil.isEmpty(leftEntries)) {
            clazz = PHPContentAssistProcessor.getNameByAlias(clazz, index, namespace, aliases, namespaceEntries);
            leftEntries = index.getEntries(1, clazz);
        }
        if (leftEntries == null) {
            leftEntries = new ArrayList<IElementEntry>();
        }
        if (leftEntries.isEmpty()) {
            HashSet<String> classMap = new HashSet<String>(1);
            classMap.add(clazz);
            Set<IElementEntry> entries = ContentAssistCollectors.collectBuiltinTypeEntries(classMap, true);
            leftEntries.addAll(entries);
        }
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : leftEntries) {
            if (!isStaticDereferencing && module != null && !module.equals(entry.getModule())) continue;
            ClassPHPEntryValue value = (ClassPHPEntryValue)entry.getValue();
            if (ContentAssistUtils.isFilterByNamespace() && !TypeHierarchyUtils.isInNamespace((AbstractPHPEntryValue)value, namespace)) continue;
            result.add(entry);
        }
        return result;
    }

    private static String pathEntryName(String entry) {
        if (ParsingUtils.isFunctionCall(entry)) {
            return ParsingUtils.getFunctionNameFromCall(entry);
        }
        return entry;
    }

    private static Set<IElementEntry> computeDereferenceRightEntries(Set<IElementEntry> leftEntries, IElementsIndex index, String right, int offset, IModule module, boolean exactMatch, boolean applyAccessModifiers, boolean innerEntries, Map<String, String> aliases, String namespace) {
        if (leftEntries == null || leftEntries.isEmpty()) {
            return null;
        }
        Set<Object> leftTypes = PHPContentAssistProcessor.getEntriesTypes(leftEntries);
        if (leftTypes == null || leftTypes.isEmpty()) {
            return null;
        }
        Set<String> resolvedLeftTypes = PHPTypeProcessor.processTypes(leftTypes, index);
        if (resolvedLeftTypes == null || resolvedLeftTypes.isEmpty()) {
            return null;
        }
        Set<String> customLeftTypes = PHPTypeProcessor.getCustomTypes(resolvedLeftTypes);
        if (customLeftTypes == null || customLeftTypes.isEmpty()) {
            return null;
        }
        IEntryFilter filter = null;
        if (applyAccessModifiers) {
            filter = innerEntries ? new AccessModifierEntryFilter(customLeftTypes, false) : new PublicsOnlyEntryFilter();
        }
        Set<String> typesWithAncestors = TypeHierarchyUtils.addAllAncestors(customLeftTypes, index, namespace, aliases);
        Set<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        boolean filterNonStatic = true;
        if (right.length() == 0) {
            Set<IElementEntry> funcResults;
            Set<IElementEntry> varResults = ContentAssistCollectors.collectVariableEntries(index, DOLLAR_SIGN, typesWithAncestors, exactMatch, aliases, namespace);
            if (varResults != null) {
                result.addAll(varResults);
            }
            if ((funcResults = ContentAssistCollectors.collectFunctionEntries(index, right, typesWithAncestors, exactMatch, aliases, namespace)) != null) {
                result.addAll(funcResults);
            }
        } else {
            String var;
            if (right.startsWith(DOLLAR_SIGN)) {
                var = right;
                filterNonStatic = false;
            } else {
                var = DOLLAR_SIGN + right;
            }
            result.addAll(ContentAssistCollectors.collectVariableEntries(index, var, typesWithAncestors, exactMatch, aliases, namespace));
            result.addAll(ContentAssistCollectors.collectFunctionEntries(index, right, typesWithAncestors, exactMatch, aliases, namespace));
        }
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (filterNonStatic) {
            result = ContentAssistFilters.filterNonStaticVariables(result);
        }
        if (filter != null) {
            result = filter.filter(result);
        }
        return ContentAssistFilters.filterByModule(result, module, index);
    }

    private static Set<IElementEntry> computeDereferenceLeftEntries(IElementsIndex index, String left, int offset, IModule module, Map<String, String> aliases, String namespace) {
        if (left.startsWith(DOLLAR_SIGN)) {
            if (THIS_ACTIVATION_SEQUENCE.equals(left)) {
                IElementEntry currentClass = PHPContentAssistProcessor.getCurrentClass(index, module, offset);
                if (currentClass == null) {
                    return null;
                }
                LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>(1);
                result.add(currentClass);
                return result;
            }
            return PHPContentAssistProcessor.getVariableEntries(index, left, namespace);
        }
        if (ParsingUtils.isFunctionCall(left)) {
            return PHPContentAssistProcessor.getFunctionEntriesByCall(index, left);
        }
        return PHPContentAssistProcessor.getClassEntries(index, left, module, aliases, namespace, false);
    }

    private static Set<IElementEntry> getFunctionEntriesByCall(IElementsIndex index, String callString) {
        List<IElementEntry> leftEntries = index.getEntries(2, callString);
        if (leftEntries == null) {
            return null;
        }
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>(leftEntries.size());
        result.addAll(leftEntries);
        return result;
    }

    private static Set<IElementEntry> getVariableEntries(IElementsIndex index, String var, String namespace) {
        String varName = var.substring(1);
        List<IElementEntry> leftEntries = index.getEntries(3, varName);
        if (leftEntries == null) {
            return null;
        }
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : leftEntries) {
            VariablePHPEntryValue value = (VariablePHPEntryValue)entry.getValue();
            if (ContentAssistUtils.isFilterByNamespace() && !TypeHierarchyUtils.isInNamespace((AbstractPHPEntryValue)value, namespace)) continue;
            result.add(entry);
        }
        return result;
    }

    private ICompletionProposal[] simpleIdentifierCompletion(int offset, String content, String identifier, Set<String> globalImports, IModule module, boolean proposeBuiltins, boolean filter, boolean ignorIndexNamespace) {
        String name = identifier;
        if (name == null) {
            return new ICompletionProposal[0];
        }
        if (name.length() == 0) {
            if (this.currentContext == null) {
                return new ICompletionProposal[0];
            }
            if (!TYPES_ACCEPTING_EMPTY_IDENTIFIERS.contains(this.currentContext.getType())) {
                return new ICompletionProposal[0];
            }
        }
        boolean variableCompletion = false;
        if (name.startsWith(DOLLAR_SIGN)) {
            name = name.substring(1);
            variableCompletion = true;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        IElementsIndex index = variableCompletion ? this.getIndex(content, offset) : this.getIndexOptimized(content, offset);
        String namespaceToUse = ignorIndexNamespace ? "" : this.namespace;
        List<IElementEntry> entries = PHPContentAssistProcessor.computeSimpleIdentifierEntries(this.reportedScopeIsGlobal, globalImports, name, variableCompletion, index, false, module, filter, this.currentContext, namespaceToUse, this.aliases);
        items.addAll(entries);
        if (proposeBuiltins) {
            List<Object> modelItems;
            String completionStart = name;
            if (completionStart.startsWith(GLOBAL_NAMESPACE)) {
                completionStart = completionStart.substring(1);
            }
            List<Object> list = modelItems = variableCompletion ? ContentAssistUtils.selectModelElements(DOLLAR_SIGN + completionStart, false) : ContentAssistUtils.selectModelElements(completionStart, false);
            if (modelItems != null) {
                for (Object modelItem : modelItems) {
                    if (variableCompletion) {
                        IPHPParseNode pn;
                        String nodeName;
                        if (modelItem instanceof PHPVariableParseNode) {
                            items.add(modelItem);
                            continue;
                        }
                        if (!(modelItem instanceof IPHPParseNode) || modelItem instanceof PHPFunctionParseNode || !(nodeName = (pn = (IPHPParseNode)modelItem).getNodeName()).startsWith(DOLLAR_SIGN) || !this.reportedScopeIsUnderClass && ALLOW_ONLY_UNDER_CLASS.contains(nodeName)) continue;
                        items.add(pn);
                        continue;
                    }
                    if (modelItem instanceof PHPVariableParseNode) continue;
                    String nodeName = ((PHPBaseParseNode)modelItem).getNodeName();
                    if (!this.reportedScopeIsUnderClass && ALLOW_ONLY_UNDER_CLASS.contains(nodeName)) continue;
                    items.add(modelItem);
                }
            }
        }
        List<ICompletionProposal> result = this.createProposals(offset, name, items, module, true, index, false);
        ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
        return result.toArray(proposals);
    }

    private IElementsIndex getIndexOptimized(String content, int offset) {
        if (this.isOutOfWorkspace || this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.PARSE_UNSAVED_MODULE_ON_IDENTIFIERS_COMPLETION")) {
            return this.getIndex(content, offset);
        }
        return PHPGlobalIndexer.getInstance().getIndex();
    }

    public static List<IElementEntry> computeSimpleIdentifierEntries(boolean reportedStackIsGlobal, Set<String> globalImports, String name, boolean variableCompletion, IElementsIndex index, boolean exactMatch, IModule module, boolean filter, String namespace, Map<String, String> aliases) {
        return PHPContentAssistProcessor.computeSimpleIdentifierEntries(reportedStackIsGlobal, globalImports, name, variableCompletion, index, exactMatch, module, filter, null, namespace, aliases);
    }

    private static List<IElementEntry> computeSimpleIdentifierEntries(boolean reportedStackIsGlobal, Set<String> globalImports, String name, boolean variableCompletion, IElementsIndex index, boolean exactMatch, IModule module, boolean filter, ProposalContext proposalContext, String namespace, Map<String, String> aliases) {
        List<Object> entries;
        List<IElementEntry> namespaceEntries = PHPContentAssistProcessor.getNamespaceEntries(name, module, aliases);
        if (proposalContext == null || !"NAMESPACE_PROPOSAL_CONTEXT_TYPE".equals(proposalContext.getType())) {
            if (!name.startsWith(GLOBAL_NAMESPACE)) {
                name = PHPContentAssistProcessor.getNameByAlias(name, index, namespace, aliases, namespaceEntries);
            } else if (!variableCompletion) {
                name = name.substring(1);
                List<IElementEntry> entriesStartingWith = index.getEntriesStartingWith(6, "");
                for (IElementEntry e : entriesStartingWith) {
                    if (!e.getEntryPath().startsWith(name)) continue;
                    namespaceEntries.add(e);
                }
            }
        }
        if (variableCompletion && (proposalContext == null || proposalContext.acceptModelElementType(3))) {
            entries = exactMatch ? index.getEntries(3, name) : index.getEntriesStartingWith(3, name);
        } else {
            Set<IElementEntry> defineEntries;
            if (exactMatch) {
                entries = new ArrayList();
                if (proposalContext == null || proposalContext.acceptModelElementType(3)) {
                    entries.addAll(index.getEntries(1, name));
                }
                if (proposalContext == null || proposalContext.acceptModelElementType(2)) {
                    entries.addAll(index.getEntries(2, name));
                }
            } else {
                entries = new ArrayList();
                if (proposalContext == null || proposalContext.acceptModelElementType(1)) {
                    List<IElementEntry> classTypeEntries = index.getEntriesStartingWith(1, name);
                    if (proposalContext != null && ("TRAIT_USE_PROPOSAL_CONTEXT_TYPE".equals(proposalContext.getType()) || "TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE".equals(proposalContext.getType()))) {
                        IContextFilter contextFilter = proposalContext.getContextFilter();
                        for (IElementEntry elementEntry : classTypeEntries) {
                            if (!contextFilter.acceptElementEntry(elementEntry)) continue;
                            entries.add(elementEntry);
                        }
                    } else {
                        entries.addAll(classTypeEntries);
                    }
                }
                if (proposalContext == null || proposalContext.acceptModelElementType(2)) {
                    entries.addAll(index.getEntriesStartingWith(2, name));
                }
                if (proposalContext == null || proposalContext.acceptModelElementType(4)) {
                    entries.addAll(index.getEntriesStartingWith(4, name));
                }
                if (proposalContext == null || proposalContext.acceptModelElementType(6)) {
                    String ns = name;
                    if (ns.startsWith(String.valueOf(namespace) + GLOBAL_NAMESPACE)) {
                        ns = ns.substring(namespace.length() + 1);
                    }
                    LinkedHashSet<IElementEntry> collectedNs = new LinkedHashSet<IElementEntry>();
                    collectedNs.addAll(index.getEntriesStartingWith(6, ns));
                    int separatorIndex = ns.lastIndexOf(GLOBAL_NAMESPACE);
                    while (separatorIndex > 0) {
                        String nsLookup = ns.substring(0, separatorIndex);
                        collectedNs.addAll(index.getEntriesStartingWith(6, nsLookup));
                        separatorIndex = nsLookup.lastIndexOf(GLOBAL_NAMESPACE);
                    }
                    entries.addAll(collectedNs);
                    if (proposalContext != null && "NAMESPACE_PROPOSAL_CONTEXT_TYPE".equals(proposalContext.getType())) {
                        entries.addAll(index.getEntriesStartingWith(1, name));
                    }
                }
            }
            if ((defineEntries = PHPContentAssistProcessor.computeDefines(name, index, proposalContext, exactMatch)) != null) {
                if (entries != null) {
                    entries.addAll(defineEntries);
                } else {
                    entries = new ArrayList<IElementEntry>(defineEntries);
                }
            }
        }
        entries.addAll(namespaceEntries);
        if (filter) {
            entries = ContentAssistFilters.filterFieldsAndMembers(entries);
        }
        if (!reportedStackIsGlobal) {
            entries = ContentAssistFilters.filterGlobalVariables(entries, globalImports);
        }
        Set<IElementEntry> filterResult = ContentAssistFilters.filterByModule(entries, module, index);
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        result.addAll(filterResult);
        return result;
    }

    public static Set<IElementEntry> computeDefines(String name, IElementsIndex index, ProposalContext proposalContext, boolean exactMatch) {
        List<IElementEntry> varEntries = null;
        if (proposalContext == null || proposalContext.acceptModelElementType(4)) {
            varEntries = exactMatch ? index.getEntries(4, name) : index.getEntriesStartingWith(4, name);
        }
        if (varEntries != null) {
            LinkedHashSet<IElementEntry> staticVariableEntries = new LinkedHashSet<IElementEntry>(5);
            for (IElementEntry entry : varEntries) {
                if (!(entry.getValue() instanceof AbstractPHPEntryValue) || !PHPFlags.isNamedConstant((int)((AbstractPHPEntryValue)entry.getValue()).getModifiers())) continue;
                staticVariableEntries.add(entry);
            }
            return staticVariableEntries;
        }
        return null;
    }

    private static List<IElementEntry> getNamespaceEntries(String name, IModule module, Map<String, String> aliases) {
        ArrayList<IElementEntry> namespaceEntries = new ArrayList<IElementEntry>();
        if (aliases != null) {
            for (String s : aliases.keySet()) {
                if (!s.toLowerCase().startsWith(name)) continue;
                namespaceEntries.add(new UnpackedEntry(-1, s, new NamespacePHPEntryValue(0, s), module));
            }
        }
        return namespaceEntries;
    }

    private static String getNameByAlias(String name, IElementsIndex index, String namespace, Map<String, String> aliases, List<IElementEntry> namespaceEntries) {
        String lowerCaseName;
        boolean foundAlias = false;
        String string = lowerCaseName = name != null ? name.toLowerCase() : "";
        if (!CollectionsUtil.isEmpty(aliases)) {
            for (String s : aliases.keySet()) {
                if (!lowerCaseName.startsWith(s.toLowerCase())) continue;
                name = String.valueOf(aliases.get(s)) + name.substring(s.length());
                foundAlias = true;
                break;
            }
        }
        if (!foundAlias && namespace != null && namespace.length() > 0 && !name.startsWith(String.valueOf(namespace) + GLOBAL_NAMESPACE)) {
            name = name.startsWith("namespace\\") ? String.valueOf(namespace) + GLOBAL_NAMESPACE + name.substring(10) : String.valueOf(namespace) + GLOBAL_NAMESPACE + name;
        }
        List<IElementEntry> entriesStartingWith = index.getEntriesStartingWith(6, "");
        for (IElementEntry e : entriesStartingWith) {
            if (!e.getEntryPath().startsWith(name)) continue;
            namespaceEntries.add(e);
        }
        return name;
    }

    private boolean hasStaticDereferenceOperatorAfterTheFirst(List<String> callPath) {
        if (callPath.size() < 3) {
            return false;
        }
        int i = 2;
        while (i < callPath.size()) {
            if (STATIC_DEREFERENCE_OP.equals(callPath.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static ICompletionProposal[] batchIncreaseReplaceLength(ICompletionProposal[] proposals, int replaceLengthIncrease) {
        if (proposals == null || proposals.length == 0 || replaceLengthIncrease == 0) {
            return proposals;
        }
        int i = 0;
        while (i < proposals.length) {
            ICompletionProposal proposal = proposals[i];
            if (proposal instanceof PHPCompletionProposal) {
                PHPCompletionProposal phpProposal = (PHPCompletionProposal)proposal;
                phpProposal.setReplacementLength(phpProposal.getReplacementLength() + replaceLengthIncrease);
            }
            ++i;
        }
        return proposals;
    }

    private IElementsIndex getIndex(String content, int offset) {
        IModule currentModule = this.getModule();
        if (currentModule == null) {
            return PHPGlobalIndexer.getInstance().getIndex();
        }
        final UnpackedElementIndex index = new UnpackedElementIndex();
        PDTPHPModuleIndexer indexer = new PDTPHPModuleIndexer(false, offset);
        indexer.indexModule(content, currentModule, new IIndexReporter(){

            @Override
            public IElementEntry reportEntry(int category, String entryPath, IReportable value, IModule module) {
                return index.addEntry(category, entryPath, value, module);
            }
        });
        this.reportedScopeIsGlobal = indexer.isReportedScopeGlobal();
        this.reportedScopeIsUnderClass = indexer.isReportedScopeUnderClass();
        this.globalImports = indexer.getGlobalImports();
        this.aliases = indexer.getAliases();
        this.namespace = indexer.getNamespace();
        ModuleSubstitutionIndex result = new ModuleSubstitutionIndex(currentModule, index, PHPGlobalIndexer.getInstance().getIndex());
        return result;
    }

    private List<ICompletionProposal> createProposals(int offset, String name, List<Object> items, IModule module, boolean applyDollarSymbol, IElementsIndex index, boolean newInstanceCompletion) {
        String origName = name;
        int lastIndexOf = name.lastIndexOf(92);
        if (lastIndexOf != -1) {
            name = name.substring(lastIndexOf + 1);
        }
        String lowerCase = name.toLowerCase();
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        LinkedHashSet<Integer> usedProposalHash = new LinkedHashSet<Integer>();
        HashMap<Object, PHPCompletionProposal> itemsToProposals = new HashMap<Object, PHPCompletionProposal>();
        for (Object item : items) {
            PHPCompletionProposal proposal;
            block9: {
                IElementEntry entry;
                int itemHash;
                String firstName;
                block12: {
                    int prefixIndex;
                    ClassPHPEntryValue classEntry;
                    String classNamespace;
                    block10: {
                        block11: {
                            block8: {
                                proposal = null;
                                if (!(item instanceof IPHPParseNode)) break block8;
                                IPHPParseNode node = (IPHPParseNode)item;
                                firstName = node.getNodeName().toLowerCase();
                                if ((firstName.startsWith(lowerCase) || applyDollarSymbol && firstName.substring(1).startsWith(lowerCase)) && !usedProposalHash.contains(itemHash = firstName.hashCode() + item.hashCode()) && (proposal = node.getNodeName().charAt(0) == '$' ? this.createProposal(node, offset, DOLLAR_SIGN + name, newInstanceCompletion) : this.createProposal(node, offset, name, newInstanceCompletion)) != null) {
                                    usedProposalHash.add(itemHash);
                                }
                                break block9;
                            }
                            if (!(item instanceof IElementEntry)) break block9;
                            entry = (IElementEntry)item;
                            firstName = entry.getCategory() != 4 && entry.getCategory() != 6 ? ElementsIndexingUtils.getLastNameInPath(entry.getEntryPath()) : entry.getEntryPath().replaceAll(String.valueOf('/'), STATIC_DEREFERENCE_OP);
                            itemHash = firstName.hashCode() + item.hashCode();
                            if (!(entry.getValue() instanceof NamespacePHPEntryValue)) break block10;
                            name = origName;
                            lowerCase = origName.toLowerCase();
                            if (!lowerCase.startsWith(GLOBAL_NAMESPACE)) break block11;
                            firstName = GLOBAL_NAMESPACE + firstName;
                            break block12;
                        }
                        if (usedProposalHash.contains(firstName)) break block12;
                        String k = firstName;
                        int p = k.indexOf(name);
                        if (p == -1) {
                            if (firstName == null || !firstName.toLowerCase().startsWith(lowerCase) || usedProposalHash.contains(firstName) || (proposal = this.createProposal(entry, offset, name, firstName, module, applyDollarSymbol, index, newInstanceCompletion)) == null) continue;
                            usedProposalHash.add(itemHash);
                            result.add((ICompletionProposal)proposal);
                            itemsToProposals.put(item, proposal);
                            continue;
                        }
                        k = k.substring(p);
                        proposal = this.createProposal(entry, offset, name, k, module, applyDollarSymbol, index, newInstanceCompletion);
                        if (proposal == null) break block12;
                        usedProposalHash.add(itemHash);
                        break block12;
                    }
                    if (this.currentContext != null && !usedProposalHash.contains(firstName) && "NAMESPACE_PROPOSAL_CONTEXT_TYPE".equals(this.currentContext.getType()) && entry.getValue() instanceof ClassPHPEntryValue && (classNamespace = (classEntry = (ClassPHPEntryValue)entry.getValue()).getNameSpace()) != null && classNamespace.length() > 0 && (prefixIndex = origName.indexOf(classNamespace)) > -1) {
                        String completionContent = String.valueOf(classNamespace) + '\\' + firstName;
                        proposal = this.createProposal(entry, offset, name, completionContent, module, applyDollarSymbol, index, newInstanceCompletion);
                        if (proposal == null) continue;
                        usedProposalHash.add(itemHash);
                        result.add((ICompletionProposal)proposal);
                        itemsToProposals.put(item, proposal);
                        continue;
                    }
                }
                String lowerCaseFirstName = firstName.toLowerCase();
                if (firstName != null && (lowerCaseFirstName.startsWith(lowerCase) || entry.getEntryPath().toLowerCase().startsWith(lowerCase)) && !usedProposalHash.contains(firstName)) {
                    String n = name;
                    if (!lowerCaseFirstName.startsWith(lowerCase)) {
                        n = "";
                    }
                    if ((proposal = this.createProposal(entry, offset, n, firstName, module, applyDollarSymbol, index, newInstanceCompletion)) != null) {
                        usedProposalHash.add(itemHash);
                    }
                }
            }
            if (proposal == null) continue;
            result.add((ICompletionProposal)proposal);
            itemsToProposals.put(item, proposal);
        }
        this.prioritizeItems(itemsToProposals, module);
        return result;
    }

    private PHPCompletionProposal createProposal(IElementEntry entry, int offset, String name, String proposalContent, IModule localModule, boolean applyDollarSymbol, IElementsIndex index, boolean newInstanceCompletion) {
        if (!this.currentContext.acceptModelsElements()) {
            return null;
        }
        if (!this.currentContext.getContextFilter().acceptElementEntry(entry)) {
            return null;
        }
        ++offset;
        String replaceString = proposalContent;
        ProposalEnhancement enhancement = this.getEnhancement(entry, proposalContent, newInstanceCompletion);
        if (enhancement != null) {
            replaceString = enhancement.replaceString;
        }
        int replOffset = offset - name.length();
        int replLength = name.length();
        int cursorPos = proposalContent.length();
        if (enhancement != null) {
            cursorPos += enhancement.cursorShift;
        }
        Image image = null;
        entry.getModule();
        Object val = entry.getValue();
        EntryDocumentationResolver resolver = new EntryDocumentationResolver(proposalContent, index, val, entry);
        image = labelProvider.getImage(val);
        String dispString = proposalContent;
        if (applyDollarSymbol && PHPContentAssistProcessor.isVariableEntry(entry) && !dispString.startsWith(DOLLAR_SIGN)) {
            dispString = DOLLAR_SIGN + dispString;
        }
        IContextInformation contextInformation = null;
        int objType = 0;
        String fileOloc = "";
        if (!(entry.getValue() instanceof NamespacePHPEntryValue)) {
            if (localModule != null && localModule.equals(entry.getModule())) {
                dispString = String.valueOf(dispString) + "-[local]";
            } else {
                IModule m = entry.getModule();
                if (m != null) {
                    dispString = String.valueOf(dispString) + "-[" + m.getShortName() + "]";
                } else if (dispString.length() == 0) {
                    dispString = entry.getEntryPath();
                }
            }
        } else {
            dispString = String.valueOf(dispString) + "-[namespace]";
        }
        String immediateTypesDisplayString = this.getImmediateTypesDisplayString(entry);
        if (immediateTypesDisplayString != null && immediateTypesDisplayString.length() > 0) {
            dispString = String.valueOf(dispString) + "-(" + immediateTypesDisplayString + ")";
        }
        PHPCompletionProposal cp = null;
        if (this.currentContext != null && this.currentContext.isAutoActivateCAAfterApply() || this.autoActivateAfterProposal(entry)) {
            cp = new AutoActivateContentAssistProposal(replaceString, replOffset, replLength, cursorPos, image, dispString, contextInformation, null, objType, fileOloc, null);
            cp.setViewer(this.viewer);
        } else {
            cp = new PHPCompletionProposal(replaceString, replOffset, replLength, cursorPos, image, dispString, contextInformation, null, objType, fileOloc, null);
        }
        cp.setViewer(this.viewer);
        if (enhancement != null && enhancement.positions != null) {
            this.increasePositions(enhancement.positions, replOffset);
            enhancement.caretExitOffset += replOffset;
            cp.setPositions(enhancement.positions, enhancement.caretExitOffset);
        }
        cp.setResolver(resolver);
        cp.setTriggerCharacters(this.getProposalTriggerCharacters());
        return cp;
    }

    private PHPCompletionProposal createProposal(final IPHPParseNode node, int offset, String name, boolean newInstanceCompletion) {
        if (!this.currentContext.acceptBuiltins()) {
            return null;
        }
        if (!this.currentContext.getContextFilter().acceptBuiltin(node)) {
            return null;
        }
        ++offset;
        final String name2 = node.getNodeName();
        String replaceString = name2;
        ProposalEnhancement enhancement = this.getEnhancement(node, replaceString, newInstanceCompletion);
        if (enhancement != null) {
            replaceString = enhancement.replaceString;
        }
        int replOffset = offset - name.length();
        int replLength = name.length();
        int cursorPos = name2.length();
        if (enhancement != null) {
            cursorPos += enhancement.cursorShift;
        }
        PHPOutlineItem outlineItem = new PHPOutlineItem(EMPTY_RANGE, node);
        Image image = labelProvider.getImage((Object)outlineItem);
        final String dispString = node.getNodeName();
        IContextInformation contextInformation = null;
        IDocumentationResolver resolver = new IDocumentationResolver(){

            @Override
            public String resolveDocumentation() {
                String additionalInfo = ContentAssistUtils.getDocumentation(node, name2);
                return additionalInfo;
            }

            @Override
            public String getProposalContent() {
                return dispString;
            }
        };
        int objType = 0;
        String fileOloc = "";
        Image[] images = new Image[]{PHPBuiltins.getInstance().existsIn(PHPVersion.PHP4, node) ? fIcon4 : fIcon4off, PHPBuiltins.getInstance().existsIn(PHPVersion.PHP5, node) ? fIcon5 : fIcon5off, PHPBuiltins.getInstance().existsIn(PHPVersion.PHP5_3, node) ? fIcon53 : fIcon53off, PHPBuiltins.getInstance().existsIn(PHPVersion.PHP5_4, node) ? fIcon54 : fIcon54off};
        PHPCompletionProposal cp = null;
        cp = this.currentContext != null && this.currentContext.isAutoActivateCAAfterApply() || this.autoActivateAfterProposal(node) ? new AutoActivateContentAssistProposal(replaceString, replOffset, replLength, cursorPos, image, dispString, contextInformation, null, objType, fileOloc, images) : new PHPCompletionProposal(replaceString, replOffset, replLength, cursorPos, image, dispString, contextInformation, null, objType, fileOloc, images);
        cp.setViewer(this.viewer);
        if (enhancement != null && enhancement.positions != null) {
            this.increasePositions(enhancement.positions, replOffset);
            enhancement.caretExitOffset += replOffset;
            cp.setPositions(enhancement.positions, enhancement.caretExitOffset);
        }
        cp.setResolver(resolver);
        return cp;
    }

    private ProposalEnhancement getEnhancement(Object entry, String proposalContent, boolean newInstanceCompletion) {
        boolean insertAllowed;
        boolean bl = insertAllowed = this.preferenceStore.getString("com.aptana.editor.php.contentassist.INSERT_MODE").equals("insert") || !this.checkParenthesesAlreadyExist();
        if (!insertAllowed) {
            return null;
        }
        ProposalEnhancement result = null;
        if (newInstanceCompletion) {
            if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_PARENTHESES_AFTER_NEW_INSTANCE")) {
                if (result == null) {
                    result = new ProposalEnhancement();
                    result.replaceString = proposalContent;
                }
                result.replaceString = String.valueOf(result.replaceString) + "()";
                result.positions = new ArrayList<Position>();
                result.positions.add(new Position(result.replaceString.length() - 1));
                result.cursorShift = 1;
            }
            if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_SEMICOLON_AFTER_NEW_INSTANCE")) {
                if (result == null) {
                    result = new ProposalEnhancement();
                    result.replaceString = proposalContent;
                }
                result.replaceString = String.valueOf(result.replaceString) + ";";
                result.cursorShift = 1;
            }
            if (result != null) {
                result.caretExitOffset = result.replaceString.length();
            }
            return result;
        }
        if (entry instanceof IElementEntry) {
            Object[] array;
            VariablePHPEntryValue m;
            Set<Object> types;
            IElementEntry elementEntry = (IElementEntry)entry;
            Object value = elementEntry.getValue();
            if (value instanceof FunctionPHPEntryValue) {
                return this.getFunctionEntryEnhancement(elementEntry, proposalContent);
            }
            if (value instanceof VariablePHPEntryValue && (types = (m = (VariablePHPEntryValue)value).getTypes()).size() == 1 && (array = types.toArray(new Object[1]))[0] != null && array[0].toString() != null && array[0].toString().startsWith("_lambda")) {
                return this.getFunctionEntryEnhancement(elementEntry, proposalContent);
            }
        } else {
            IPHPParseNode nodeEntry;
            if (entry instanceof PHPFunctionParseNode) {
                return this.getFunctionNodeEnhancement((PHPFunctionParseNode)entry, proposalContent);
            }
            if (entry instanceof IPHPParseNode && (nodeEntry = (IPHPParseNode)entry).getNodeType() == 4505 && ("extends".equals(nodeEntry.getNodeName()) || "implements".equals(nodeEntry.getNodeName()) || "new".equals(nodeEntry.getNodeName()))) {
                result = new ProposalEnhancement();
                result.replaceString = String.valueOf(nodeEntry.getNodeName()) + " ";
                result.caretExitOffset = result.replaceString.length();
                result.cursorShift = 1;
                result.positions = new ArrayList<Position>();
            }
        }
        return result;
    }

    private boolean checkParenthesesAlreadyExist() {
        int i = this.offset;
        while (i < this.content.length()) {
            char ch = this.content.charAt(i);
            if (ch == '(') {
                return true;
            }
            if (!Character.isWhitespace(ch)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    private ProposalEnhancement getFunctionEntryEnhancement(IElementEntry elementEntry, String proposalContent) {
        ProposalEnhancement result = null;
        if ("TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE".equals(this.currentContext.getType())) {
            result = new ProposalEnhancement();
            result.replaceString = proposalContent;
            result.caretExitOffset = result.replaceString.length();
            result.cursorShift = 0;
            result.positions = new ArrayList<Position>();
            return result;
        }
        if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_PARENTHESES_AFTER_METHOD_CALLS") || this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_FUNCTION_PARAMETERS")) {
            if (result == null) {
                result = new ProposalEnhancement();
                result.replaceString = proposalContent;
            }
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_FUNCTION_PARAMETERS")) {
                if (elementEntry.getValue() instanceof VariablePHPEntryValue) {
                    VariablePHPEntryValue vv = (VariablePHPEntryValue)elementEntry.getValue();
                    String sm = (String)vv.getTypes().iterator().next();
                    int indexOf = sm.indexOf(40);
                    int la = sm.indexOf(41);
                    String pNames = sm.substring(indexOf + 1, la);
                    String[] parNames = pNames.split(",");
                    if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.PARAMETRS_TAB_JUMP")) {
                        result.positions = new ArrayList<Position>();
                    }
                    this.updateResult(result, builder, Arrays.asList(parNames));
                    builder.append(')');
                    result.replaceString = String.valueOf(result.replaceString) + builder.toString();
                    result.cursorShift = 1;
                    return result;
                }
                FunctionPHPEntryValue entryValue = (FunctionPHPEntryValue)elementEntry.getValue();
                if (entryValue.getParameters() != null) {
                    if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.PARAMETRS_TAB_JUMP")) {
                        result.positions = new ArrayList<Position>();
                    }
                    ArrayList<String> parameterNames = new ArrayList<String>(entryValue.getParameters().size());
                    if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_OPTIONAL_FUNCTION_PARAMETERS")) {
                        parameterNames.addAll(entryValue.getParameters().keySet());
                    } else {
                        boolean[] mandatoryParams;
                        Iterator<String> namesIterator = entryValue.getParameters().keySet().iterator();
                        boolean[] blArray = mandatoryParams = entryValue.getMandatoryParams();
                        int n = mandatoryParams.length;
                        int n2 = 0;
                        while (n2 < n) {
                            boolean isMandatory = blArray[n2];
                            String name = namesIterator.next();
                            if (isMandatory) {
                                parameterNames.add(name);
                            }
                            ++n2;
                        }
                    }
                    this.updateResult(result, builder, parameterNames);
                }
            }
            builder.append(')');
            result.replaceString = String.valueOf(result.replaceString) + builder.toString();
            result.cursorShift = 1;
        }
        if (elementEntry.getValue() instanceof FunctionPHPEntryValue && this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_SEMICOLON_AFTER_METHOD_CALLS")) {
            if (result == null) {
                result = new ProposalEnhancement();
                result.replaceString = proposalContent;
            }
            result.replaceString = String.valueOf(result.replaceString) + ";";
            result.cursorShift = 1;
        }
        if (result != null) {
            result.caretExitOffset = result.replaceString.length();
        }
        return result;
    }

    private void updateResult(ProposalEnhancement result, StringBuilder builder, List<String> parameterNames) {
        int i = 0;
        while (i < parameterNames.size() - 1) {
            String parameterName = parameterNames.get(i);
            int start = builder.length() + result.replaceString.length();
            builder.append('$');
            builder.append(parameterName);
            int length = builder.length() + result.replaceString.length() - start;
            builder.append(", ");
            if (result.positions != null) {
                result.positions.add(new Position(start, length));
            }
            ++i;
        }
        if (parameterNames.size() > 0) {
            int start = builder.length() + result.replaceString.length();
            builder.append('$');
            builder.append(parameterNames.get(parameterNames.size() - 1));
            int length = builder.length() + result.replaceString.length() - start;
            if (result.positions != null) {
                result.positions.add(new Position(start, length));
            }
        } else {
            result.positions.add(new Position(builder.length() + result.replaceString.length(), 0));
        }
    }

    private ProposalEnhancement getFunctionNodeEnhancement(PHPFunctionParseNode node, String proposalContent) {
        ProposalEnhancement result = null;
        if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_PARENTHESES_AFTER_METHOD_CALLS") || this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_FUNCTION_PARAMETERS")) {
            if (result == null) {
                result = new ProposalEnhancement();
                result.replaceString = proposalContent;
            }
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_FUNCTION_PARAMETERS")) {
                Parameter[] parameters = node.getParameters();
                if (parameters != null && parameters.length != 0) {
                    String name;
                    boolean insertOptionals = this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_OPTIONAL_FUNCTION_PARAMETERS");
                    if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.PARAMETRS_TAB_JUMP")) {
                        result.positions = new ArrayList<Position>();
                    }
                    boolean commaAppended = false;
                    int i = 0;
                    while (i < parameters.length - 1) {
                        if (parameters[i].getDefaultValue() != null && !insertOptionals && !"".equals(parameters[i].getDefaultValue())) break;
                        String parameterName = parameters[i].getVariableName();
                        if (parameterName != null && !parameterName.startsWith(DOLLAR_SIGN)) {
                            parameterName = DOLLAR_SIGN + parameterName;
                            int start = builder.length() + result.replaceString.length();
                            builder.append(parameterName);
                            int length = builder.length() + result.replaceString.length() - start;
                            builder.append(", ");
                            commaAppended = true;
                            if (result.positions != null) {
                                result.positions.add(new Position(start, length));
                            }
                        }
                        ++i;
                    }
                    int start = builder.length() + result.replaceString.length();
                    if ((insertOptionals || parameters[parameters.length - 1].getDefaultValue() == null || !insertOptionals && "".equals(parameters[parameters.length - 1].getDefaultValue())) && (name = parameters[parameters.length - 1].getVariableName()) != null && !name.startsWith(DOLLAR_SIGN)) {
                        name = DOLLAR_SIGN + name;
                        builder.append(name);
                        int length = builder.length() + result.replaceString.length() - start;
                        if (result.positions != null) {
                            result.positions.add(new Position(start, length));
                        }
                        commaAppended = false;
                    }
                    if (commaAppended) {
                        builder.delete(builder.length() - 2, builder.length());
                    }
                } else {
                    result.positions = new ArrayList<Position>();
                    result.positions.add(new Position(builder.length() + result.replaceString.length(), 0));
                }
            }
            builder.append(')');
            result.replaceString = String.valueOf(result.replaceString) + builder.toString();
            result.cursorShift = 1;
        }
        if (this.preferenceStore.getBoolean("com.aptana.editor.php.contentassist.INSERT_SEMICOLON_AFTER_METHOD_CALLS")) {
            if (result == null) {
                result = new ProposalEnhancement();
                result.replaceString = proposalContent;
            }
            result.replaceString = String.valueOf(result.replaceString) + ";";
            result.cursorShift = 1;
        }
        if (result != null) {
            result.caretExitOffset = result.replaceString.length();
        }
        return result;
    }

    private String getImmediateTypesDisplayString(IElementEntry entry) {
        Object entryValue = entry.getValue();
        if (entryValue instanceof ClassPHPEntryValue) {
            return "";
        }
        if (entryValue instanceof FunctionPHPEntryValue) {
            Set<Object> returnTypes = ((FunctionPHPEntryValue)entryValue).getReturnTypes();
            if (CollectionsUtil.isEmpty(returnTypes)) {
                return "";
            }
            ArrayList<String> knownTypes = new ArrayList<String>();
            for (Object type : returnTypes) {
                if (!(type instanceof String)) continue;
                knownTypes.add((String)type);
            }
            if (knownTypes.size() == 0) {
                return "...";
            }
            String typesString = PHPContentAssistProcessor.getTypesDisplayString(knownTypes, entry);
            if (knownTypes.size() != returnTypes.size()) {
                typesString = String.valueOf(typesString) + ", ...";
            }
            return typesString;
        }
        if (entryValue instanceof VariablePHPEntryValue) {
            Set<Object> variableTypes = ((VariablePHPEntryValue)entryValue).getTypes();
            if (variableTypes == null || variableTypes.size() == 0) {
                return "";
            }
            ArrayList<String> knownTypes = new ArrayList<String>();
            for (Object type : variableTypes) {
                if (!(type instanceof String)) continue;
                knownTypes.add((String)type);
            }
            if (knownTypes.size() == 0) {
                return "...";
            }
            String typesString = PHPContentAssistProcessor.getTypesDisplayString(knownTypes, entry);
            if (variableTypes.size() != knownTypes.size()) {
                typesString = String.valueOf(typesString) + ", ...";
            }
            return typesString;
        }
        return "";
    }

    private static String getTypesDisplayString(List<String> types, IElementEntry entry) {
        ArrayList<String> sortedTypes = new ArrayList<String>(types.size());
        sortedTypes.addAll(types);
        Collections.sort(sortedTypes);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < sortedTypes.size() - 1) {
            String type = (String)sortedTypes.get(i);
            result.append(type);
            result.append(", ");
            ++i;
        }
        result.append((String)sortedTypes.get(sortedTypes.size() - 1));
        return ContentAssistUtils.truncateLineIfNeeded(result.toString());
    }

    private boolean autoActivateAfterProposal(Object item) {
        IPHPParseNode node;
        return item instanceof IPHPParseNode && (node = (IPHPParseNode)item).getNodeType() == 4505 && "new".equals(node.getNodeName());
    }

    private void increasePositions(List<Position> positions, int offset) {
        for (Position pos : positions) {
            pos.offset += offset;
        }
    }

    private IModule getModule() {
        if (this.module == null) {
            PHPSourceEditor phpSourceEditor = (PHPSourceEditor)this.editor;
            this.module = phpSourceEditor.getModule();
            this.isOutOfWorkspace = phpSourceEditor.isOutOfWorkspace();
        }
        return this.module;
    }

    private static boolean isVariableEntry(IElementEntry entry) {
        if (entry.getCategory() != 3) {
            return false;
        }
        if (entry.getValue() == null) {
            return false;
        }
        return entry.getValue() instanceof VariablePHPEntryValue;
    }

    private static boolean isConstVariable(IElementEntry entry) {
        if (!PHPContentAssistProcessor.isVariableEntry(entry)) {
            return false;
        }
        int modifier = ((VariablePHPEntryValue)entry.getValue()).getModifiers();
        return PHPFlags.isStatic((int)modifier) && PHPFlags.isFinal((int)modifier);
    }

    private static boolean isFunctionEntry(IElementEntry entry) {
        if (entry.getCategory() != 2 && entry.getCategory() != 7) {
            return false;
        }
        if (entry.getValue() == null) {
            return false;
        }
        return entry.getValue() instanceof FunctionPHPEntryValue;
    }

    private static boolean isClassEntry(IElementEntry entry) {
        if (entry.getCategory() != 1) {
            return false;
        }
        if (entry.getValue() == null) {
            return false;
        }
        return entry.getValue() instanceof ClassPHPEntryValue;
    }

    private void prioritizeItems(Map<Object, PHPCompletionProposal> itemsToProposals, IModule localModule) {
        ArrayList<Object> externals = new ArrayList<Object>();
        for (Object item : itemsToProposals.keySet()) {
            if (item instanceof IElementEntry) {
                if (localModule == null || localModule.equals(((IElementEntry)item).getModule())) {
                    itemsToProposals.get(item).setRelevance(95);
                    continue;
                }
                externals.add(item);
                continue;
            }
            externals.add(item);
        }
        for (Object item : externals) {
            if (item instanceof IElementEntry) {
                IElementEntry entry = (IElementEntry)item;
                switch (entry.getCategory()) {
                    case 1: {
                        itemsToProposals.get(item).setRelevance(40);
                        break;
                    }
                    case 2: {
                        itemsToProposals.get(item).setRelevance(35);
                        break;
                    }
                    case 4: {
                        itemsToProposals.get(item).setRelevance(30);
                        break;
                    }
                    default: {
                        itemsToProposals.get(item).setRelevance(25);
                        break;
                    }
                }
                continue;
            }
            if (item instanceof PHPBaseParseNode) {
                PHPBaseParseNode parseNode = (PHPBaseParseNode)item;
                switch (parseNode.getNodeType()) {
                    case 4505: {
                        itemsToProposals.get(item).setRelevance(88);
                        break;
                    }
                    case 4500: {
                        itemsToProposals.get(item).setRelevance(38);
                        break;
                    }
                    case 4501: {
                        itemsToProposals.get(item).setRelevance(33);
                        break;
                    }
                    case 4503: {
                        itemsToProposals.get(item).setRelevance(28);
                        break;
                    }
                    default: {
                        itemsToProposals.get(item).setRelevance(23);
                        break;
                    }
                }
                continue;
            }
            itemsToProposals.get(item).setRelevance(20);
        }
    }

    private int countReplaceLengthIncrease(String content, int offset) {
        if (!this.preferenceStore.getString("com.aptana.editor.php.contentassist.INSERT_MODE").equals("overwrite")) {
            return 0;
        }
        int i = offset;
        while (i < content.length()) {
            char ch = content.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                return i - offset;
            }
            ++i;
        }
        return 0;
    }

    private boolean checkInclude(String token) {
        if (token != null) {
            return "PHP_INCLUDE".equals(token) || "PHP_INCLUDE_ONCE".equals(token) || "PHP_REQUIRE".equals(token) || "PHP_REQUIRE_ONCE".equals(token);
        }
        return false;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        if (document == null) {
            return EMPTY_CONTEXT_INFO;
        }
        String content = document.get();
        int start = offset;
        try {
            ITypedRegion partition = document.getPartition(offset);
            while (partition != null && partition.getOffset() > 0 && !"__common_start_switch_tag".equals(partition.getType())) {
                if (offset - (partition = document.getPartition(partition.getOffset() - 1)).getOffset() > 100) break;
            }
            start = partition.getOffset();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (Throwable)e);
        }
        ILexemeProvider<PHPTokenType> lexemeProvider = ParsingUtils.createLexemeProvider(document, start, offset);
        CallInfo info = PHPContextCalculator.calculateCallInfo(lexemeProvider, offset);
        if (info == null) {
            return EMPTY_CONTEXT_INFO;
        }
        List<Object> items = ContentAssistUtils.selectModelElements(info.getName(), true);
        if (items.size() == 0) {
            Set<IElementEntry> entries = null;
            IElementsIndex index = this.getIndex(content, offset);
            ITypedRegion partition = viewer.getDocument().getDocumentPartitioner().getPartition(offset);
            List<String> callPath = ParsingUtils.parseCallPath(partition, content, info.getNameEndPos(), OPS, false, document);
            if (callPath == null || callPath.isEmpty()) {
                return EMPTY_CONTEXT_INFO;
            }
            if (callPath.size() > 1) {
                entries = DEREFERENCE_OP.equals(callPath.get(1)) ? PHPContentAssistProcessor.computeDereferenceEntries(index, callPath, info.getNameEndPos(), this.getModule(), true, this.aliases, this.namespace) : PHPContentAssistProcessor.computeStaticDereferenceEntries(index, callPath, info.getNameEndPos(), this.getModule(), true, this.aliases, this.namespace);
            } else {
                List<IElementEntry> res = PHPContentAssistProcessor.computeSimpleIdentifierEntries(this.reportedScopeIsGlobal, this.globalImports, info.getName(), false, index, true, this.getModule(), false, this.namespace, this.aliases);
                if (res != null) {
                    entries = new LinkedHashSet<IElementEntry>();
                    entries.addAll(res);
                }
            }
            if (entries == null) {
                return EMPTY_CONTEXT_INFO;
            }
            if ((entries = ContentAssistFilters.filterAllButFunctions(entries, index)).size() == 0) {
                return EMPTY_CONTEXT_INFO;
            }
            IElementEntry funcEntry = entries.iterator().next();
            IContextInformation ci = PHPContextCalculator.computeArgContextInformation(funcEntry, info.getNameEndPos());
            if (ci == null || StringUtil.isEmpty((String)ci.getInformationDisplayString())) {
                return EMPTY_CONTEXT_INFO;
            }
            IContextInformation[] res = new IContextInformation[]{ci};
            return res;
        }
        IPHPParseNode pn = (IPHPParseNode)items.get(0);
        IContextInformation[] ici = null;
        IContextInformation ci = null;
        if (pn instanceof PHPFunctionParseNode) {
            ci = PHPContextCalculator.computeArgContextInformation((PHPFunctionParseNode)pn, info.getNameEndPos());
        } else if (pn instanceof PHPClassParseNode) {
            ci = PHPContextCalculator.computeConstructorContextInformation((PHPClassParseNode)pn, info.getNameEndPos());
        }
        ici = ci != null ? new IContextInformation[]{ci} : EMPTY_CONTEXT_INFO;
        return ici;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return autoactivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return contextInformationActivationChars;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new PHPContextInformationValidator();
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.php";
    }
}

